/******************************************************
 * Instruction Set Architecture header file.          *
 * This file is automatically generated by ArchC      *
 * WITHOUT WARRANTY OF ANY KIND, either express       *
 * or implied.                                        *
 * For more information on ArchC, please visit:       *
 * http://www.archc.org                               *
 *                                                    *
 * The ArchC Team                                     *
 * Computer Systems Laboratory (LSC)                  *
 * IC-UNICAMP                                         *
 * http://www.lsc.ic.unicamp.br                       *
 ******************************************************/

#ifndef _NIOS32_ISA_H_
#define _NIOS32_ISA_H_

#include "ac_arch_dec_if.H"
#include "ac_decoder_rt.H"
#include "ac_instr.H"
#include "ac_instr_info.H"

#include "nios32_parms.H"
#include "nios32_arch.H"
#include "nios32_arch_ref.H"
#include "nios32_stages_ref.H"

namespace nios32_parms
{
 class nios32_isa: public nios32_arch_ref, public nios32_stages_ref
 {
  private:
   typedef ac_instr<AC_DEC_FIELD_NUMBER> ac_instr_t;

  public:
   unsigned current_instruction_id;
   //! Decoding structures.
   static ac_dec_field fields[AC_DEC_FIELD_NUMBER];
   static ac_dec_format formats[AC_DEC_FORMAT_NUMBER];
   static ac_dec_list dec_list[AC_DEC_LIST_NUMBER];
   static ac_dec_instr instructions[AC_DEC_INSTR_NUMBER];
   static const ac_instr_info instr_table[AC_DEC_INSTR_NUMBER + 1];
   ac_decoder_full* decoder;

   //! Standard constructor.
   nios32_isa(nios32_arch& ref, nios32_pipe_IF::nios32_pipe_IF& pipe_IF_ref, ac_sync_reg<ac_instr_t>& pr_pipe_IF_pipe_ID_ref, nios32_pipe_ID::nios32_pipe_ID& pipe_ID_ref, ac_sync_reg<ac_instr_t>& pr_pipe_ID_pipe_EX_ref, nios32_pipe_EX::nios32_pipe_EX& pipe_EX_ref, ac_sync_reg<ac_instr_t>& pr_pipe_EX_pipe_MEM_ref, nios32_pipe_MEM::nios32_pipe_MEM& pipe_MEM_ref, ac_sync_reg<ac_instr_t>& pr_pipe_MEM_pipe_WB_ref, nios32_pipe_WB::nios32_pipe_WB& pipe_WB_ref): nios32_arch_ref(ref), nios32_stages_ref(pipe_IF_ref, pr_pipe_IF_pipe_ID_ref, pipe_ID_ref, pr_pipe_ID_pipe_EX_ref, pipe_EX_ref, pr_pipe_EX_pipe_MEM_ref, pipe_MEM_ref, pr_pipe_MEM_pipe_WB_ref, pipe_WB_ref)
   {
    //! Building decoder.
    decoder = ac_decoder_full::CreateDecoder(nios32_isa::formats, nios32_isa::instructions, &ref);
    return;
   }

   inline const char* get_name()
   {
    return instr_table[current_instruction_id].ac_instr_name;
   }

   inline const char* get_name(unsigned id)
   {
    return instr_table[id].ac_instr_name;
   }

   inline const char* get_mnemonic()
   {
    return instr_table[current_instruction_id].ac_instr_mnemonic;
   }

   inline const char* get_mnemonic(unsigned id)
   {
    return instr_table[id].ac_instr_mnemonic;
   }

   inline const unsigned get_size()
   {
    return instr_table[current_instruction_id].ac_instr_size;
   }

   inline const unsigned get_size(unsigned id)
   {
    return instr_table[id].ac_instr_size;
   }

   inline const unsigned get_min_latency()
   {
    return instr_table[current_instruction_id].ac_instr_size;
   }

   inline const unsigned get_min_latency(unsigned id)
   {
    return instr_table[id].ac_instr_size;
   }

   inline const unsigned get_max_latency()
   {
    return instr_table[current_instruction_id].ac_instr_size;
   }

   inline const unsigned get_max_latency(unsigned id)
   {
    return instr_table[id].ac_instr_size;
   }

   void _behavior_instruction(ac_stage_list stage, unsigned cycle, unsigned nu);

   void _behavior_begin();
   void _behavior_end();

   void _behavior_nios32_Format_RR(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void _behavior_nios32_Format_Ri5(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void _behavior_nios32_Format_Ri4(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int CONST_0, unsigned int imm4, unsigned int ra, unsigned int nu);
   void _behavior_nios32_Format_RPi5(ac_stage_list stage, unsigned cycle, unsigned int op4, unsigned int rp, unsigned int imm5, unsigned int ra, unsigned int nu);
   void _behavior_nios32_Format_Ri6(ac_stage_list stage, unsigned cycle, unsigned int op5, unsigned int imm6, unsigned int ra, unsigned int nu);
   void _behavior_nios32_Format_Ri8(ac_stage_list stage, unsigned cycle, unsigned int op3, unsigned int imm8, unsigned int ra, unsigned int nu);
   void _behavior_nios32_Format_i9(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm9, unsigned int CONST_1, unsigned int nu);
   void _behavior_nios32_Format_i10(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm10, unsigned int nu);
   void _behavior_nios32_Format_i11(ac_stage_list stage, unsigned cycle, unsigned int op5, unsigned int imm11, unsigned int nu);
   void _behavior_nios32_Format_Ri1u(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op3u, unsigned int imm1u, unsigned int CONST_2, unsigned int ra, unsigned int nu);
   void _behavior_nios32_Format_Ri2u(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op3u, unsigned int imm2u, unsigned int ra, unsigned int nu);
   void _behavior_nios32_Format_i8v(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op2v, unsigned int imm8v, unsigned int nu);
   void _behavior_nios32_Format_i6v(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op2v, unsigned int CONST_3, unsigned int imm6v, unsigned int nu);
   void _behavior_nios32_Format_Rw(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void _behavior_nios32_Format_i4w(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int CONST_4, unsigned int imm4w, unsigned int nu);
   void _behavior_nios32_Format_w(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int CONST_5, unsigned int nu);

   void behavior_add(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_and1(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_andn1(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_asr(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_cmp(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_ext16d(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_ext8d(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_ld(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_lsl(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_lsr(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_mov(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_nop(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_st(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_sub(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_usr0(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_or1(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_xor1(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int rb, unsigned int ra, unsigned int nu);
   void behavior_addi(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_and2(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_andn2(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_asri(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_bgen(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_cmpi(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_if0(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_if1(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_lsli(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_lsri(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_movhi(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_movi(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_skp0(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_skp1(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_subi(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_or2(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_xor2(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_ldp(ac_stage_list stage, unsigned cycle, unsigned int op4, unsigned int rp, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_stp(ac_stage_list stage, unsigned cycle, unsigned int op4, unsigned int rp, unsigned int imm5, unsigned int ra, unsigned int nu);
   void behavior_lds(ac_stage_list stage, unsigned cycle, unsigned int op3, unsigned int imm8, unsigned int ra, unsigned int nu);
   void behavior_sts(ac_stage_list stage, unsigned cycle, unsigned int op3, unsigned int imm8, unsigned int ra, unsigned int nu);
   void behavior_syscall(ac_stage_list stage, unsigned cycle, unsigned int op3, unsigned int imm8, unsigned int ra, unsigned int nu);
   void behavior_sts16s(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm9, unsigned int CONST_1, unsigned int nu);
   void behavior_sts8s(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int imm10, unsigned int nu);
   void behavior_br(ac_stage_list stage, unsigned cycle, unsigned int op5, unsigned int imm11, unsigned int nu);
   void behavior_bsr(ac_stage_list stage, unsigned cycle, unsigned int op5, unsigned int imm11, unsigned int nu);
   void behavior_pfx(ac_stage_list stage, unsigned cycle, unsigned int op5, unsigned int imm11, unsigned int nu);
   void behavior_pfxio(ac_stage_list stage, unsigned cycle, unsigned int op5, unsigned int imm11, unsigned int nu);
   void behavior_ext16s(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op3u, unsigned int imm1u, unsigned int CONST_2, unsigned int ra, unsigned int nu);
   void behavior_st16s(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op3u, unsigned int imm1u, unsigned int CONST_2, unsigned int ra, unsigned int nu);
   void behavior_ext8s(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op3u, unsigned int imm2u, unsigned int ra, unsigned int nu);
   void behavior_st8s(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op3u, unsigned int imm2u, unsigned int ra, unsigned int nu);
   void behavior_save(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op2v, unsigned int imm8v, unsigned int nu);
   void behavior_trap(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op2v, unsigned int CONST_3, unsigned int imm6v, unsigned int nu);
   void behavior_abs(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_call(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_fill16(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_fill8(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_ifrnz(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_ifrz(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_jmp(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_lret(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_mstep(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_mul(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_neg(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_not(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_rdctl(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_ret(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_rlc(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_rrc(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_sext16(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_sext8(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_skprnz(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_skprz(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_st16d(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_st8d(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_swap(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_tret(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_usr1(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_usr2(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_usr3(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_usr4(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_wrctl(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int ra, unsigned int nu);
   void behavior_ifs(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int CONST_4, unsigned int imm4w, unsigned int nu);
   void behavior_skps(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int CONST_4, unsigned int imm4w, unsigned int nu);
   void behavior_restore(ac_stage_list stage, unsigned cycle, unsigned int op6, unsigned int op5w, unsigned int CONST_5, unsigned int nu);
 };
};

#endif // _NIOS32_ISA_H_
